/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.com/copyright-license

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

#include "/lib/head.glsl"

out vec2 coord;

flat out float exposure;

uniform sampler2D colortex3;
uniform sampler2D colortex4;

uniform float frameTime;
uniform float nightVision;

uniform vec2 bloomResolution;
uniform vec2 pixelSize, viewSize;

float temporalExp(float currLum) {
    float expCurr   = clamp(texture(colortex4, vec2(0.5)).a, 0.0, 65535.0);
    float expTarg   = rcp(currLum);
        expTarg     = clamp(expTarg, 0.5, 50.0 * rcp(exposureMinlum) + nightVision*15.0);
        expTarg     = log2(expTarg * rcp(8.0));    //adjust this
        expTarg     = 1.2 * pow(2.0, expTarg);

    return mix(expCurr, expTarg, 0.035 * exposureSpeed * (frameTime * crcp(0.033)));
}

void main() {
    gl_Position = vec4(gl_Vertex.xy * 2.0 - 1.0, 0.0, 1.0);
    
    //vec2 cres   = max(viewSize, bloomResolution);
    //gl_Position.xy = (gl_Position.xy*0.5+0.5)*0.5/cres*bloomResolution*2.0-1.0;

    vec2 rscale     = min(viewSize, bloomResolution);
    vec2 rscale2    = bloomResolution/max(viewSize, bloomResolution);

    //exposure    = 1.0;

    ivec2 resolution    = ivec2(rscale * rcp(86.0));

    float sum       = 0.0;

    ivec2 startPos  = ivec2((0.46875 * rscale2.x * viewSize.x) + 8.0 + 0.5, 0.0);

    float sumWeight = 0.0;
    int iterations  = 0;

    for (int x = 0; x <= resolution.x; ++x) {
        for (int y = 0; y <= resolution.y; ++y) {
            //vec2 pos    = vec2(x, y) / resolution;
            //float weight = exp(-length(pos * 2.0 - 1.0) * 1.5) * 0.7 + 0.3;

            sum    += getLuma(texelFetch(colortex3, startPos + ivec2(x, y), 0).rgb);
            //sumWeight += weight;
            iterations++;
        }
    }

    //sum    *= rcp(max(sumWeight, 1e-20));

    sum    *= rcp(float(iterations));

    #ifdef newExposure
    exposure = temporalExp(sum);
    #endif

    coord = gl_MultiTexCoord0.xy;
}